#ICEBEAR 10 antenna analysis
#author: Devin Huyghebaert
#Date: Jan. 6, 2019

#Description: ICEBEAR spectra signal processing.  This is un-optimized code, but will produce the ICEBEAR spectra.
#Note that this uses a rolling code, whereas the publication describes the use of a shifted code.  The results will be similar.

#libraries
import scipy as scipy
import numpy as np
import cmath as math
import math as mat
import h5py

#antenna phase corrections in degrees
phase_corr = [0,-10.9,-24.205,-25.09,-1.615,20.145,-28.82,-5.79,12.98,4.435]

#approximate median value of the antenna channel, can be used for rough calibration 
mag_corr =[17.4928556845,10.1980390272,9.21954445729,9.21954445729,10.0,9.48683298051,8.24621125124,10.0,10.295630141,9.43398113206]

#create an array to store the complex values for the phase and magnitude corrections
complex_corr = np.zeros(10,dtype=complex)

#calculate complex numbers to amplitude and phase shift antenna data by
for x in range(10):
	complex_corr[x] = math.rect(1.0/mag_corr[x],math.pi*phase_corr[x]/180.0)

#sample rate of receiver
sample_rate=200000

#ranges
nrang = 2000

#number of averages
averages = 50

#array for storing the code to be analyzed
b_code = np.zeros((20000),dtype=np.float32)

#read in code to be tested
test_sig = scipy.fromfile(open("icebear_first_publication_data/pseudo_random_code_800kHz_transmission.code"),dtype=scipy.complex64)

y=0

#sample code at 1/4 of the tx rate
for x in range(80000):
	if ((x+1)%4==0):
		if (test_sig[x]>0.0):
			b_code[y]=1.0
			y+=1
		else:
			b_code[y]=-1.0
			y+=1

codelen=20000

#variable for the decimate rate
fdec=200

code_rolled = np.zeros((20000,nrang),dtype=np.complex64)

#calculate the 1-D code array for each range
for x in range(nrang):
	code_rolled[:,x] = np.roll(b_code,x)

#set aside space for the post-decimated cross spectra
antennas_uncoded = np.zeros((20000,nrang,10),dtype=np.complex64)
antennas_uncoded_decimated = np.zeros((20000/fdec,nrang,10),dtype=np.complex64)
antennas_spectra = np.zeros((20000/fdec,nrang,10),dtype=np.complex64)
spec01 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec12 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec23 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec34 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec45 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec56 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec67 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec78 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
spec89 = np.zeros((20000/fdec,nrang),dtype=np.complex64)
total_angular_diff = np.zeros((20000/fdec,nrang),dtype=np.float)

#cycle through the user defined number of averages
for avg_num in range(averages):
	
	print avg_num

	#get the data for each antenna and parse it
	print('getting data')

	antenna_file = h5py.File('icebear_first_publication_data/antenna0/rf@1520651640.000.h5', 'r')
	antenna_data0 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data0 = (np.asarray(zip(*antenna_data0)[0])+(1j*np.asarray(zip(*antenna_data0)[1])))*complex_corr[0]

	antenna_file = h5py.File('icebear_first_publication_data/antenna1/rf@1520651640.000.h5', 'r')
	antenna_data1 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data1 = (np.asarray(zip(*antenna_data1)[0])+(1j*np.asarray(zip(*antenna_data1)[1])))*complex_corr[1]

	antenna_file = h5py.File('icebear_first_publication_data/antenna2/rf@1520651640.000.h5', 'r')
	antenna_data2 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data2 = (np.asarray(zip(*antenna_data2)[0])+(1j*np.asarray(zip(*antenna_data2)[1])))*complex_corr[2]

	antenna_file = h5py.File('icebear_first_publication_data/antenna3/rf@1520651640.000.h5', 'r')
	antenna_data3 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data3 = (np.asarray(zip(*antenna_data3)[0])+(1j*np.asarray(zip(*antenna_data3)[1])))*complex_corr[3]

	antenna_file = h5py.File('icebear_first_publication_data/antenna4/rf@1520651640.000.h5', 'r')
	antenna_data4 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data4 = (np.asarray(zip(*antenna_data4)[0])+(1j*np.asarray(zip(*antenna_data4)[1])))*complex_corr[4]

	antenna_file = h5py.File('icebear_first_publication_data/antenna5/rf@1520651640.000.h5', 'r')
	antenna_data5 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data5 = (np.asarray(zip(*antenna_data5)[0])+(1j*np.asarray(zip(*antenna_data5)[1])))*complex_corr[5]

	antenna_file = h5py.File('icebear_first_publication_data/antenna6/rf@1520651640.000.h5', 'r')
	antenna_data6 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data6 = (np.asarray(zip(*antenna_data6)[0])+(1j*np.asarray(zip(*antenna_data6)[1])))*complex_corr[6]

	antenna_file = h5py.File('icebear_first_publication_data/antenna7/rf@1520651640.000.h5', 'r')
	antenna_data7 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data7 = (np.asarray(zip(*antenna_data7)[0])+(1j*np.asarray(zip(*antenna_data7)[1])))*complex_corr[7]

	antenna_file = h5py.File('icebear_first_publication_data/antenna8/rf@1520651640.000.h5', 'r')
	antenna_data8 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data8 = (np.asarray(zip(*antenna_data8)[0])+(1j*np.asarray(zip(*antenna_data8)[1])))*complex_corr[8]

	antenna_file = h5py.File('icebear_first_publication_data/antenna9/rf@1520651640.000.h5', 'r')
	antenna_data9 = antenna_file['rf_data'][(avg_num*20000):((avg_num+1)*20000),0]
	antenna_data9 = (np.asarray(zip(*antenna_data9)[0])+(1j*np.asarray(zip(*antenna_data9)[1])))*complex_corr[9]

	#decode the signal for each antenna
	for y in range(nrang):
		antennas_uncoded[:,y,0] = np.conj(code_rolled[:,y])*antenna_data0
		antennas_uncoded[:,y,1] = np.conj(code_rolled[:,y])*antenna_data1
		antennas_uncoded[:,y,2] = np.conj(code_rolled[:,y])*antenna_data2
		antennas_uncoded[:,y,3] = np.conj(code_rolled[:,y])*antenna_data3
		antennas_uncoded[:,y,4] = np.conj(code_rolled[:,y])*antenna_data4
		antennas_uncoded[:,y,5] = np.conj(code_rolled[:,y])*antenna_data5
		antennas_uncoded[:,y,6] = np.conj(code_rolled[:,y])*antenna_data6
		antennas_uncoded[:,y,7] = np.conj(code_rolled[:,y])*antenna_data7
		antennas_uncoded[:,y,8] = np.conj(code_rolled[:,y])*antenna_data8
		antennas_uncoded[:,y,9] = np.conj(code_rolled[:,y])*antenna_data9
	
	#decimate the data
	for dec_loop in range(20000/fdec):
		for y in range(nrang):
			for antenna in range(10):
				antennas_uncoded_decimated[dec_loop,y,antenna] = np.sum(antennas_uncoded[(dec_loop*fdec):((dec_loop+1)*fdec-1),y,antenna])

	#calculate the spectra for each antenna
	for y in range(nrang):
		for antenna in range(10):
			antennas_spectra[:,y,antenna] = np.fft.fft(antennas_uncoded_decimated[:,y,antenna])
	
	#sum the cross spectra if doing multiple scan averaging
	spec01+=antennas_spectra[:,:,0]*np.conj(antennas_spectra[:,:,1])
	spec12+=antennas_spectra[:,:,1]*np.conj(antennas_spectra[:,:,2])
	spec23+=antennas_spectra[:,:,2]*np.conj(antennas_spectra[:,:,3])
	spec34+=antennas_spectra[:,:,3]*np.conj(antennas_spectra[:,:,4])
	spec45+=antennas_spectra[:,:,4]*np.conj(antennas_spectra[:,:,5])
	spec56+=antennas_spectra[:,:,5]*np.conj(antennas_spectra[:,:,6])
	spec67+=antennas_spectra[:,:,6]*np.conj(antennas_spectra[:,:,7])
	spec78+=antennas_spectra[:,:,7]*np.conj(antennas_spectra[:,:,8])
	spec89+=antennas_spectra[:,:,8]*np.conj(antennas_spectra[:,:,9])

#sum the phases to get the total phase difference across the array.  Aliasing is not accounted for in this code.
total_angular_diff = np.angle(spec01)+np.angle(spec12)+np.angle(spec23)+np.angle(spec34)+np.angle(spec45)+np.angle(spec56)+np.angle(spec67)+np.angle(spec78)+np.angle(spec89)

#wavelength
lam=6.06

#determine the power spectrum
pwr=(np.abs(spec01)+np.abs(spec23)+np.abs(spec45)+np.abs(spec67)+np.abs(spec89))/5.0

#calculate the fft frequencies
fft_freq = np.fft.fftshift(np.fft.fftfreq(20000/fdec,fdec/200000.0))

#shift the FFT so 0 Hz is the center of the array
pwr=np.fft.fftshift(pwr,axes=0)
total_angular_diff = np.fft.fftshift(total_angular_diff,axes=0)

#use the median of the spectrum as the noise level
noise=np.median(pwr)

#determine the signal-to-noise
snr=(pwr-noise)/noise

#calculate the angle of arrival
theta=np.arcsin((total_angular_diff)*lam/(9.0*6.0*2.0*mat.pi))

#mask the angles of arrival where the snr is less than 1.0
theta = np.ma.masked_where(snr < 1.0,theta)

#mask snr where snr is less than 1.0
snr = np.ma.masked_where(snr < 1.0,snr)

